/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.inventory;

import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import vazkii.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import vazkii.quark.addons.oddities.module.MatrixEnchantingModule;

public class MatrixEnchantingMenu
extends AbstractContainerMenu {
    public final MatrixEnchantingTableBlockEntity enchanter;

    public MatrixEnchantingMenu(int id, Inventory playerInv, MatrixEnchantingTableBlockEntity tile) {
        super(MatrixEnchantingModule.menuType, id);
        this.enchanter = tile;
        this.m_38897_(new Slot((Container)tile, 0, 15, 20){

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot((Container)tile, 1, 15, 44){

            public boolean m_5857_(@Nonnull ItemStack stack) {
                return MatrixEnchantingMenu.this.isLapis(stack);
            }
        });
        this.m_38897_(new Slot((Container)tile, 2, 59, 32){

            public boolean m_5857_(@Nonnull ItemStack stack) {
                return false;
            }

            public void m_142406_(@Nonnull Player thePlayer, @Nonnull ItemStack stack) {
                MatrixEnchantingMenu.this.finish(thePlayer, stack);
                super.m_142406_(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
    }

    public static MatrixEnchantingMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        MatrixEnchantingTableBlockEntity te = (MatrixEnchantingTableBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(pos);
        return new MatrixEnchantingMenu(windowId, playerInventory, te);
    }

    private boolean isLapis(ItemStack stack) {
        return stack.m_204117_(Tags.Items.GEMS_LAPIS);
    }

    private void finish(Player player, ItemStack stack) {
        this.enchanter.m_6836_(0, ItemStack.f_41583_);
        player.m_36220_(Stats.f_12964_);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10575_.m_27668_(serverPlayer, stack, 1);
        }
        player.f_19853_.m_5594_(null, this.enchanter.m_58899_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, player.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        BlockPos pos;
        Level world = this.enchanter.m_58904_();
        if (world.m_8055_(pos = this.enchanter.m_58899_()).m_60734_() != MatrixEnchantingModule.matrixEnchanter) {
            return false;
        }
        return playerIn.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            originalStack = stackInSlot.m_41777_();
            if (index < 3) {
                if (!this.m_38903_(stackInSlot, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.isLapis(stackInSlot)) {
                if (!this.m_38903_(stackInSlot, 1, 2, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (((Slot)this.f_38839_.get(0)).m_6657_() || !((Slot)this.f_38839_.get(0)).m_5857_(stackInSlot)) {
                    return ItemStack.f_41583_;
                }
                if (stackInSlot.m_41782_()) {
                    ((Slot)this.f_38839_.get(0)).m_5852_(stackInSlot.m_41620_(1));
                } else if (!stackInSlot.m_41619_()) {
                    ((Slot)this.f_38839_.get(0)).m_5852_(new ItemStack((ItemLike)stackInSlot.m_41720_(), 1));
                    stackInSlot.m_41774_(1);
                }
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == originalStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stackInSlot);
        }
        return originalStack;
    }
}

